<?php
// upload.php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $main_title = $_POST['main_title'] ?? '';
    $line1 = $_POST['line1'] ?? '';
    $line2 = $_POST['line2'] ?? '';
    $telegram = $_POST['telegram'] ?? '';
    $whatsapp = $_POST['whatsapp'] ?? '';
    $image_url = '';

    // Handle image upload
    if (isset($_FILES['banner_image']) && $_FILES['banner_image']['error'] === UPLOAD_ERR_OK) {
        $img_name = basename($_FILES['banner_image']['name']);
        $target_dir = 'uploads/';
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $target_file = $target_dir . uniqid() . '_' . $img_name;
        if (move_uploaded_file($_FILES['banner_image']['tmp_name'], $target_file)) {
            $image_url = $target_file;
        }
    }

    $stmt = $conn->prepare("INSERT INTO banners (image_url, main_title, line1, line2, telegram, whatsapp) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('ssssss', $image_url, $main_title, $line1, $line2, $telegram, $whatsapp);
    $stmt->execute();
    $stmt->close();
    header('Location: index.php');
    exit;
}
?>
