<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Join Us</title>
  <style>
    :root{
      --bg1:#ff6b6b;
      --bg2:#f7b733;
      --bg3:#4ecdc4;
      --card-bg:rgba(255,255,255,0.12);
      --glass:rgba(255,255,255,0.06);
      --accent:#ffffff;
      --btn-tele:#0088cc;
      --btn-wa:#25D366;
      --radius:14px;
      --ease:cubic-bezier(.16,.84,.44,1);
    }

    html,body{
      height:100%;
      margin:0;
      font-family:Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
      color:var(--accent);
      background: linear-gradient(120deg,var(--bg1),var(--bg2),var(--bg3));
      background-size: 600% 600%;
      animation: gradientShift 12s ease infinite;
      display:flex;
      align-items:center;
      justify-content:center;
    }

    @keyframes gradientShift{
      0%{background-position:0% 50%}
      50%{background-position:100% 50%}
      100%{background-position:0% 50%}
    }

    .card{
      width:clamp(300px, 60vw, 900px);
      padding:36px;
      border-radius:var(--radius);
      background:linear-gradient(180deg, rgba(255,255,255,0.06), rgba(255,255,255,0.03));
      box-shadow: 0 8px 30px rgba(0,0,0,0.18), inset 0 1px 0 rgba(255,255,255,0.04);
      backdrop-filter: blur(8px) saturate(120%);
      text-align:center;
      transform: translateY(0);
      animation: floatIn 800ms var(--ease) both;
    }

    @keyframes floatIn{
      from{opacity:0; transform: translateY(12px) scale(.99)}
      to{opacity:1; transform: translateY(0) scale(1)}
    }

    .lines{
      margin:0 0 22px 0;
      padding:0;
      line-height:1.05;
    }

    .line{
      font-weight:600;
      letter-spacing: -0.02em;
      opacity:0;
      transform: translateY(8px);
      animation: appear 700ms var(--ease) forwards;
    }

    .line:nth-child(1){ font-size: clamp(20px, 4.2vw, 36px); animation-delay:120ms; }
    .line:nth-child(2){ font-size: clamp(16px, 2.2vw, 20px); font-weight:500; color: rgba(255,255,255,0.95); animation-delay:260ms; margin-top:8px;}
    .line:nth-child(3){ font-size: clamp(12px, 1.8vw, 14px); font-weight:400; color: rgba(255,255,255,0.85); animation-delay:420ms; margin-top:10px;}

    @keyframes appear{
      to{opacity:1; transform: translateY(0)}
    }

    .actions{
      display:flex;
      gap:14px;
      justify-content:center;
      margin-top:18px;
      flex-wrap:wrap;
    }

    .btn{
      display:inline-flex;
      align-items:center;
      gap:10px;
      padding:12px 18px;
      border-radius:12px;
      text-decoration:none;
      color:#fff;
      font-weight:600;
      box-shadow: 0 6px 18px rgba(0,0,0,0.12);
      transition: transform 200ms var(--ease), box-shadow 200ms var(--ease), filter 200ms var(--ease);
      border: none;
      cursor:pointer;
    }

    .btn:active{ transform: translateY(1px) scale(.998) }

    .btn-telegram{
      background: linear-gradient(180deg, var(--btn-tele), #0077b3);
    }
    .btn-wa{
      background: linear-gradient(180deg, #28d67a, var(--btn-wa));
    }

    .btn svg{ width:18px; height:18px; flex-shrink:0; filter: drop-shadow(0 2px 6px rgba(0,0,0,0.12)); }

    .btn:hover{ transform: translateY(-4px); box-shadow:0 12px 30px rgba(0,0,0,0.18); }

    .sub{
      margin-top:14px;
      font-size:12px;
      color:rgba(255,255,255,0.7);
      opacity:0;
      transform: translateY(6px);
      animation: appear 700ms var(--ease) forwards;
      animation-delay:640ms;
    }

    footer{
      margin-top:18px;
      font-size:11px;
      opacity:0.7;
      color:rgba(255,255,255,0.75);
    }

    /* add banner styles */
    .banner{
      display:inline-block;
      margin:0 auto 14px;
      padding:6px 14px;
      border-radius:999px;
      background: linear-gradient(90deg, rgba(255,255,255,0.14), rgba(255,255,255,0.06));
      color:rgba(255,255,255,0.98);
      font-weight:700;
      letter-spacing:0.02em;
      font-size:13px;
      box-shadow: 0 6px 18px rgba(0,0,0,0.12), inset 0 1px 0 rgba(255,255,255,0.04);
      backdrop-filter: blur(6px);
      animation: bannerPop 700ms var(--ease) both;
    }
    @keyframes bannerPop{
      from{opacity:0; transform:translateY(-6px) scale(.98)}
      to{opacity:1; transform:none}
    }

    @media (max-width:420px){
      .card{ padding:20px; border-radius:12px; }
      .actions{ gap:10px; }
      .btn{ padding:10px 14px; font-size:14px; }
    }
  </style>
</head>
<body>
  <div style="display: flex; justify-content: center; align-items: flex-start; gap: 32px; width: 100vw; min-height: 100vh;">
    <?php
    include 'db.php';
    $banner = $conn->query("SELECT * FROM banners ORDER BY id DESC LIMIT 1")->fetch_assoc();
    ?>
    <main class="card" role="main" aria-labelledby="main-title">
      <?php if ($banner && !empty($banner['image_url'])): ?>
        <img src="<?php echo htmlspecialchars($banner['image_url']); ?>" alt="Banner" style="width:100%; max-width:1200px; height:auto; border-radius:18px; box-shadow:0 8px 32px rgba(0,0,0,0.18); margin:24px 0 0 0; object-fit:cover;" />
      <?php else: ?>
        <img src="https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=1200&q=80" alt="Banner" style="width:100%; max-width:1200px; height:auto; border-radius:18px; box-shadow:0 8px 32px rgba(0,0,0,0.18); margin:24px 0 0 0; object-fit:cover;" />
      <?php endif; ?>
      <div class="lines" aria-hidden="false">
        <div id="main-title" class="line"><?php echo $banner ? htmlspecialchars($banner['main_title']) : 'Welcome to Our Community'; ?></div>
        <div class="line"><?php echo $banner ? htmlspecialchars($banner['line1']) : 'Connect, collaborate, and stay updated'; ?></div>
        <div class="line"><?php echo $banner ? htmlspecialchars($banner['line2']) : 'Fast support, friendly members, daily updates'; ?></div>
      </div>
      <div class="actions" role="group" aria-label="Join links">
        <a class="btn btn-wa" href="<?php echo $banner ? htmlspecialchars($banner['whatsapp']) : 'https://chat.whatsapp.com/yourinvite'; ?>" target="_blank" rel="noopener noreferrer" title="Join on WhatsApp">
          <!-- WhatsApp phone bubble SVG -->
          <svg viewBox="0 0 24 24" fill="none" aria-hidden="true" focusable="false">
            <path d="M20.5 3.5A11 11 0 0 0 2.8 17.6L2 22l4.7-.78A11 11 0 1 0 20.5 3.5z" fill="#ffffff" opacity="0.95"/>
            <path d="M17 14.2c-.3-.15-1.7-.85-2-.95-.35-.12-.6-.15-.85.15-.25.3-1 1-1.1 1.2-.1.2-.2.35-.05.6.15.25.6.85 1 1.3.7.7 1.5 1.3 2.7 1.8 1.2.45 1.9.4 2.2.35.3-.05 1-1.2 1.1-2.4.1-1.2-.7-1.85-1-1.95z" fill="#25D366"/>
          </svg>
          Join WhatsApp
        </a>
        <a class="btn btn-telegram" href="<?php echo $banner ? htmlspecialchars($banner['telegram']) : 'https://t.me/yourchannel'; ?>" target="_blank" rel="noopener noreferrer" title="Join on Telegram">
          <!-- Telegram paper plane SVG -->
          <svg viewBox="0 0 24 24" fill="none" aria-hidden="true" focusable="false">
            <path d="M22 3L2 12.5l4.5 1.6L9 21l3-5 6.5 4L22 3z" fill="#ffffff" opacity="0.95"/>
          </svg>
          Join Telegram
        </a>
      </div>
      <p class="sub">Click a button to open the group invite in a new tab.</p>
      <footer>Safe & friendly community • Fast replies</footer>
    </main>
    <!-- Form Side -->

  </div>
</body>
</html>