<?php
// add_banner.php
include 'db.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Add Banner Data</title>
  <style>
    body {
      background: linear-gradient(120deg,#ff6b6b,#f7b733,#4ecdc4);
      font-family: Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
      color: #222;
      min-height: 100vh;
      margin: 0;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .form-card {
      background: rgba(255,255,255,0.08);
      border-radius: 16px;
      box-shadow: 0 4px 16px rgba(0,0,0,0.08);
      padding: 32px;
      width: 100%;
      max-width: 420px;
      margin: 32px auto;
    }
    h2 {
      margin-bottom: 18px;
      color: #222;
      text-align: center;
    }
    label {
      display: block;
      margin-bottom: 10px;
      color: #222;
      font-weight: 500;
    }
    input[type="text"], input[type="url"] {
      margin-bottom: 18px;
      width: 100%;
      padding: 8px;
      border-radius: 8px;
      border: 1px solid #ccc;
      font-size: 1rem;
    }
    input[type="file"] {
      margin-bottom: 18px;
      width: 100%;
    }
    button {
      background: #0097e6;
      color: #fff;
      border: none;
      border-radius: 8px;
      padding: 12px 24px;
      font-weight: 600;
      cursor: pointer;
      width: 100%;
      font-size: 1rem;
    }
    button:hover {
      background: #0077b3;
    }
  </style>
</head>
<body>
  <form class="form-card" action="upload.php" method="post" enctype="multipart/form-data">
    <h2>Add Banner Data</h2>
    <label>Banner Image</label>
    <input type="file" name="banner_image" accept="image/*" required />
    <label>Main Title</label>
    <input type="text" name="main_title" required />
    <label>Line 1</label>
    <input type="text" name="line1" required />
    <label>Line 2</label>
    <input type="text" name="line2" required />
    <label>Telegram Link</label>
    <input type="url" name="telegram" required />
    <label>WhatsApp Group Link</label>
    <input type="url" name="whatsapp" required />
    <button type="submit">Add Banner</button>
  </form>
</body>
</html>
